/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.IOException;
import java.io.Writer;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyUnicode;

public class PyFileWriter
extends PyObject {
    private final Writer writer;
    private boolean closed;
    public boolean softspace = false;

    public PyFileWriter(Writer writer) {
        this.writer = writer;
        this.closed = false;
    }

    public boolean closed() {
        return this.closed;
    }

    public void checkClosed() {
        if (this.closed()) {
            throw Py.ValueError("I/O operation on closed file");
        }
    }

    public synchronized void flush() {
        this.checkClosed();
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public void close() {
        try {
            this.writer.close();
            this.closed = true;
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public void write(PyObject pyObject) {
        if (pyObject instanceof PyUnicode) {
            this.write(((PyUnicode)pyObject).getString());
        } else if (pyObject instanceof PyString) {
            this.write(((PyString)pyObject).getString());
        } else {
            throw Py.TypeError("write requires a string as its argument");
        }
    }

    public synchronized void write(String string) {
        this.checkClosed();
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public synchronized void writelines(PyObject pyObject) {
        this.checkClosed();
        PyObject pyObject2 = Py.iter(pyObject, "writelines() requires an iterable argument");
        PyObject pyObject3 = null;
        while ((pyObject3 = pyObject2.__iternext__()) != null) {
            if (!(pyObject3 instanceof PyString)) {
                throw Py.TypeError("writelines() argument must be a sequence of strings");
            }
            this.write(pyObject3);
        }
    }
}

